/*
 * Decompiled with CFR 0.152.
 */
package shieldbreak.handlers;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shieldbreak.handlers.ModConfig;
import shieldbreak.util.PotionEntry;

public class EventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingAttack(LivingAttackEvent event) {
        ItemStack playerItem;
        if (event.getEntityLiving().field_70170_p.field_72995_K || event.isCanceled() || !(event.getEntityLiving() instanceof EntityPlayer) || !(event.getSource().func_76346_g() instanceof EntityLivingBase) || event.getAmount() <= 0.0f) {
            return;
        }
        World world = event.getEntityLiving().field_70170_p;
        DamageSource damageSource = event.getSource();
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        EntityLivingBase attacker = (EntityLivingBase)damageSource.func_76346_g();
        Float damageAmount = Float.valueOf(event.getAmount());
        if (!this.canPlayerBlockDamageSource(player, damageSource)) {
            return;
        }
        ItemStack itemStack = playerItem = player.func_184587_cr() ? player.func_184607_cu() : ItemStack.field_190927_a;
        if (!(playerItem.func_77973_b() instanceof ItemShield)) {
            return;
        }
        ItemStack attackerItem = attacker.func_184586_b(attacker.func_184600_cs());
        event.setCanceled(true);
        if (this.damageShield(player, playerItem, event.getAmount())) {
            return;
        }
        if (!attackerItem.func_190926_b() && attackerItem.func_77973_b().canDisableShield(attackerItem, playerItem, (EntityLivingBase)player, attacker)) {
            float chance = ModConfig.server.shieldBypassChance + (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)attackerItem) * 0.05f;
            if (world.field_73012_v.nextFloat() < chance) {
                player.func_184811_cZ().func_185145_a(playerItem.func_77973_b(), ModConfig.server.shieldBypassCooldown);
                player.func_184602_cy();
                world.func_72960_a((Entity)player, (byte)30);
                this.doPotionEffects(attacker, (EntityLivingBase)player, false);
                return;
            }
        }
        int parryTicks = player.func_184612_cw();
        float shieldDurability = playerItem.func_77958_k() > 0 ? playerItem.func_77958_k() : ModConfig.server.unbreakableShieldDurability;
        float shieldProtection = Math.max(ModConfig.server.damageMinimumThreshold, Math.min(ModConfig.server.damageMaximumThreshold, shieldDurability / ModConfig.server.damageDurabilityScaling));
        float knockbackPower = ModConfig.server.knockbackNormal;
        boolean parry = false;
        boolean broken = false;
        if (parryTicks < ModConfig.server.parryTickRange + ModConfig.server.shieldRaiseTickDelay) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187767_eL, SoundCategory.PLAYERS, 1.0f, 0.3f);
            knockbackPower = ModConfig.server.knockbackParry;
            parry = true;
        } else if (damageAmount.floatValue() > shieldProtection) {
            player.func_184811_cZ().func_185145_a(playerItem.func_77973_b(), (int)Math.max((float)ModConfig.server.cooldownTicksMinimum, Math.min((float)ModConfig.server.cooldownTicksMaximum, (damageAmount.floatValue() - shieldProtection) * ModConfig.server.cooldownTicksScaling)));
            player.func_184602_cy();
            world.func_72960_a((Entity)player, (byte)30);
            knockbackPower = ModConfig.server.knockbackBreak;
            broken = true;
        } else {
            world.func_72960_a((Entity)player, (byte)29);
        }
        if (!damageSource.func_76352_a()) {
            attacker.func_70653_a((Entity)player, knockbackPower, player.field_70165_t - attacker.field_70165_t, player.field_70161_v - attacker.field_70161_v);
            if (attacker instanceof EntityPlayerMP) {
                ((EntityPlayerMP)attacker).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)attacker));
            }
            if (parry || broken) {
                this.doPotionEffects(attacker, (EntityLivingBase)player, parry);
            }
        }
        if (ModConfig.server.alwaysResetActiveHand) {
            player.func_184602_cy();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.isCanceled() || !(event.getItemStack().func_77973_b() instanceof ItemShield)) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        float shieldDurability = itemStack.func_77958_k() > 0 ? itemStack.func_77958_k() : ModConfig.server.unbreakableShieldDurability;
        float shieldProtection = Math.max(ModConfig.server.damageMinimumThreshold, Math.min(ModConfig.server.damageMaximumThreshold, shieldDurability / ModConfig.server.damageDurabilityScaling));
        double shieldProtectionRounded = (double)((int)(shieldProtection * 100.0f)) / 100.0;
        event.getToolTip().add(TextFormatting.GREEN + I18n.func_135052_a((String)"tooltip.shieldbreak.shieldingpower", (Object[])new Object[0]) + " " + shieldProtectionRounded + TextFormatting.RESET);
    }

    private void doPotionEffects(EntityLivingBase attacker, EntityLivingBase defender, boolean parry) {
        List<PotionEntry> defenderEffect;
        List<PotionEntry> attackerEffect;
        if (parry) {
            attackerEffect = ModConfig.server.getEffectAttackerParry();
            defenderEffect = ModConfig.server.getEffectDefenderParry();
        } else {
            attackerEffect = ModConfig.server.getEffectAttackerBreak();
            defenderEffect = ModConfig.server.getEffectDefenderBreak();
        }
        if (attackerEffect != null) {
            for (PotionEntry entry : attackerEffect) {
                attacker.func_70690_d(new PotionEffect(entry.getPotion(), entry.getDuration(), entry.getAmplifier()));
            }
        }
        if (defenderEffect != null) {
            for (PotionEntry entry : defenderEffect) {
                defender.func_70690_d(new PotionEffect(entry.getPotion(), entry.getDuration(), entry.getAmplifier()));
            }
        }
    }

    private boolean canPlayerBlockDamageSource(EntityPlayer playerIn, DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && this.isActiveItemStackBlockingWithDelay(playerIn) && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = playerIn.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private boolean isActiveItemStackBlockingWithDelay(EntityPlayer playerIn) {
        if (playerIn.func_184587_cr() && !playerIn.func_184607_cu().func_190926_b()) {
            Item item = playerIn.func_184607_cu().func_77973_b();
            if (item.func_77661_b(playerIn.func_184607_cu()) != EnumAction.BLOCK) {
                return false;
            }
            return playerIn.func_184612_cw() >= ModConfig.server.shieldRaiseTickDelay;
        }
        return false;
    }

    private boolean damageShield(EntityPlayer playerIn, ItemStack shieldIn, float damage) {
        ItemStack shieldCopy = shieldIn.func_77946_l();
        int i = Math.max(1, (int)damage);
        shieldIn.func_77972_a(i, (EntityLivingBase)playerIn);
        if (playerIn.func_184607_cu().func_190926_b()) {
            EnumHand hand = playerIn.func_184600_cs();
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)playerIn, (ItemStack)shieldCopy, (EnumHand)hand);
            playerIn.func_184201_a(hand.equals((Object)EnumHand.MAIN_HAND) ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
            playerIn.func_184602_cy();
            playerIn.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + playerIn.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            return true;
        }
        return false;
    }
}

